#include "General.h"

sqlite3 *DB::Database;

void DB::Load()
{
	if(sqlite3_open("AzazelBot.db", &Database) != 0)
	{
		Console_Output("Could not open database, creating new database...\n");
		return;
	}
	Create_Tables();
}

void DB::Unload()
{
	sqlite3_close(Database);
}

void DB::Create_Tables()
{
	Query("CREATE TABLE IF NOT EXISTS Bans (BanLength varchar(24), UID INTEGER PRIMARY KEY, Nick TEXT, IP TEXT, WhoBy TEXT, Reason TEXT, Time INTERGER)");
	Query("CREATE TABLE IF NOT EXISTS Ranks(Nick char(32), Points INERGER, Kills INERGER, Deaths INERGER, VehicleKills INERGER, BuildingKills INERGER, RankPoints INERGER, GDI INERGER, Nod INERGER, Games INERGER)");
	Query("CREATE TABLE IF NOT EXISTS JoinMessage (Message varchar(128), Nick varchar(64))");
	Query("CREATE TABLE IF NOT EXISTS Log(Type TEXT, Action TEXT, time INERGER)");
	Query("CREATE TABLE IF NOT EXISTS PlayerSettings (Forced TEXT, uID INTEGER PRIMARY KEY, Nick TEXT, ShowPM TEXT, Muted TEXT, Shunned TEXT, Beacons TEXT, StatsBanned TEXT)"); 
	Query("CREATE TABLE IF NOT EXISTS Players (Serial TEXT, ipaddress varchar(32), uid INTEGER PRIMARY KEY, Nick char(32))");
	Query("CREATE TABLE IF NOT EXISTS RecCount (Name varchar(32), Recs varchar(12))");
	Query("CREATE TABLE IF NOT EXISTS Recommendations (Name varchar(32), Posted varchar(32), TimeStamp INERGER)");
	Query("CREATE TABLE IF NOT EXISTS SerialBans (Serial TEXT, UID INTEGER PRIMARY KEY)");
}

bool DB::Query(const char *Format, ...)
{
	DLOG;

	va_list va;
	_crt_va_start(va, Format);
	char *buffer = sqlite3_vmprintf(Format, va);
	va_end(va);

	char *Error = 0;
	if(sqlite3_exec(Database, buffer, NULL, 0, &Error) != 0)
	{
		StringClass Return = Error;
		IRC::SendC(CHAN_PUBLIC,"Sqlite error: %s\n", Error);
		sqlite3_free(Error);
		sqlite3_free(buffer);
		return false;
	}
	sqlite3_free(buffer);
	return true;
}

bool DB::Query(DynamicVectorClass<Row*>* VectorOut, const char *Format, ...)
{
	DLOG;

	va_list va;
	_crt_va_start(va, Format);
	char *buffer = sqlite3_vmprintf(Format, va);
	va_end(va);

	char *Error = 0;
	if(sqlite3_exec(Database, buffer, Callback, VectorOut, &Error) != 0)
	{
		StringClass Return = Error;
		IRC::SendC(CHAN_PUBLIC, "Sqlite error: %s\n", Error);
		sqlite3_free(Error);
		sqlite3_free(buffer);

		if (VectorOut)
		{
			VectorOut->Delete_All();
		}
		return false;
	}
	sqlite3_free(buffer);
	return true;
}

int DB::Callback(void *Data, int argc, char **ColumnData, char **Columns)
{
	DLOG;
	DynamicVectorClass<Row *> *l = (DynamicVectorClass<Row *> *)Data;

	if (!l)
	{
		return 0;
	}

	Row *r = new Row;
	r->Columns = new DynamicVectorClass<Column *>;

	for (int i = 0; i < argc; i++)
	{
		Column* c = new Column;
		c->Name = (Columns[i]);
		c->Data = ColumnData[i] ? ColumnData[i] : "NULL";
		
		r->Columns->Add(c);
	}
	
	l->Add(r);

	return 0;
}

void DB::Delete_Result(DynamicVectorClass<Row *>* List)
{
	DLOG;

	if(!List)
	{
		return;
	}
	if(List->Length() == 0)
	{
		return;
	}

	for (int i = 0; i < List->Count(); i++)
	{
		Row *r = List->operator[](i);

		for(int j = 0; j < r->Columns->Count(); j++)
		{
			Column *c = r->Columns->operator[](j);
			delete[] c->Data;
			delete[] c->Name;
		}
		r->Columns->Delete_All();
		delete r->Columns;
	}
	
	List->Delete_All();
	delete List;
}

StringClass DB::Get_Column_Data(const char *Name, DynamicVectorClass<Column *> *Row)
{
	DLOG;
	Column *c;
	for(int i = 0; i < Row->Count(); i++)
	{
		if (!c)
		{
			break;
		}

		if(strcmp(c->Name, Name) == 0)
		{	
			return c->Data;
		}
	}

	return 0;
}